/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.acoustics;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.registry.acoustics.EventType;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.acoustics.IOptions;
import org.orecruncher.dsurround.registry.acoustics.ISoundPlayer;

@SideOnly(value=Side.CLIENT)
public class EventSelectorAcoustics
implements IAcoustic {
    private final String name;
    private final Map<EventType, IAcoustic> pairs = new EnumMap<EventType, IAcoustic>(EventType.class);

    public EventSelectorAcoustics(@Nonnull String acousticName) {
        this.name = acousticName;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public void playSound(@Nonnull ISoundPlayer player2, @Nonnull Vec3d location, @Nullable EventType event, @Nullable IOptions inputOptions) {
        IAcoustic acoustic = this.pairs.get((Object)event);
        if (acoustic != null) {
            acoustic.playSound(player2, location, event, inputOptions);
        } else if (event != null && event.canTransition()) {
            this.playSound(player2, location, event.getTransitionDestination(), inputOptions);
        }
    }

    public void setAcousticPair(@Nonnull EventType type, @Nonnull IAcoustic acoustic) {
        this.pairs.put(type, acoustic);
    }

    public String toString() {
        return this.getName();
    }
}

